program CardGame;

uses Math;

const
  MAXN = 200005;

type
  TCount = array[1..MAXN] of LongInt;
  TSegmentTree = record
    Count: array[1..4*MAXN] of LongInt; // ?????? ???? ?????? ? ??????
    Sum: array[1..4*MAXN] of Int64; // ?????? ???? ????????? ?????? ? ?????? (Sigma v * PairCount[v])
  end;

var
  N, Q: LongInt;
  A: TCount; // ??????? ??? A
  C: TCount; // ???? ??????????? C[v]
  TotalSumOdd: Int64; // R_O: ???? ???? v ?? ???? ?? C[v] ???????
  TotalPairs: LongInt; // S: ?????? ???? ?????? (Sigma PairCount[v])
  Tree: TSegmentTree;

// ????????? Segment Tree-? (Segment Tree ?? ????? ?? ??????????? 1..N)
procedure UpdateTree(Node, L, R, Index: LongInt; NewPairCount: LongInt);
var
  Mid: LongInt;
begin
  if L = R then
  begin
    // Index = Vrednost v
    Tree.Count[Node] := NewPairCount;
    Tree.Sum[Node] := NewPairCount * Index;
    exit;
  end;

  Mid := (L + R) div 2;
  if Index <= Mid then
    UpdateTree(2 * Node, L, Mid, Index, NewPairCount)
  else
    UpdateTree(2 * Node + 1, Mid + 1, R, Index, NewPairCount);

  Tree.Count[Node] := Tree.Count[2 * Node] + Tree.Count[2 * Node + 1];
  Tree.Sum[Node] := Tree.Sum[2 * Node] + Tree.Sum[2 * Node + 1];
end;

// ???? ?? ???? ???????? K ??????
// ?????? ???? ???????? K ?????? (2*K ??????) ????????? Segment Tree
function QuerySmallestPairsSum(Node, L, R: LongInt; K: LongInt): Int64;
var
  Mid: LongInt;
begin
  if K = 0 then
  begin
    Result := 0;
    exit;
  end;

  // ??? ?? K ???? ??? ??????? ????? ???? ?????? ? ???? ???-??????, ????? ???? ????
  if Tree.Count[Node] <= K then
  begin
    Result := Tree.Sum[Node];
    exit;
  end;

  // ??? ??? ????? ?? ?????
  if L = R then
  begin
    // ??? ???????? v ?? K-?? ???????. ??????? K ?????? ??? ?????????.
    Result := K * L;
    exit;
  end;

  Mid := (L + R) div 2;

  if Tree.Count[2 * Node] >= K then
  begin
    Result := QuerySmallestPairsSum(2 * Node, L, Mid, K);
  end
  else
  begin
    Result := Tree.Sum[2 * Node];
    Result := Result + QuerySmallestPairsSum(2 * Node + 1, Mid + 1, R, K - Tree.Count[2 * Node]);
  end;
end;


procedure Type2Query(X, Y: LongInt);
var
  V_Old, V_New: LongInt;
  OldPairCount, NewPairCount: LongInt;
begin
  V_Old := A[X];
  V_New := Y;

  if V_Old = V_New then Exit;


  if Odd(C[V_Old]) then TotalSumOdd := TotalSumOdd - V_Old;

  OldPairCount := C[V_Old] div 2;
  TotalPairs := TotalPairs - OldPairCount;
  C[V_Old] := C[V_Old] - 1;
  NewPairCount := C[V_Old] div 2;
  TotalPairs := TotalPairs + NewPairCount;

  if OldPairCount <> NewPairCount then
    UpdateTree(1, 1, N, V_Old, NewPairCount);

  if Odd(C[V_Old]) then TotalSumOdd := TotalSumOdd + V_Old;

  if Odd(C[V_New]) then TotalSumOdd := TotalSumOdd - V_New;

  OldPairCount := C[V_New] div 2;
  TotalPairs := TotalPairs - OldPairCount;
  C[V_New] := C[V_New] + 1;
  NewPairCount := C[V_New] div 2;
  TotalPairs := TotalPairs + NewPairCount;

  if OldPairCount <> NewPairCount then
    UpdateTree(1, 1, N, V_New, NewPairCount);

  if Odd(C[V_New]) then TotalSumOdd := TotalSumOdd + V_New;

  A[X] := Y;
end;

procedure Type1Query(K: LongInt);
var
  P, S, NumNonPlayedPairs: LongInt;
  RP: Int64;
begin
  P := N - K;
  S := TotalPairs;

  if P >= S then
  begin

    WriteLn(TotalSumOdd);
  end
  else
  begin

    NumNonPlayedPairs := S - P; 
    RP := QuerySmallestPairsSum(1, 1, N, NumNonPlayedPairs);

    WriteLn(TotalSumOdd + 2 * RP);
  end;
end;

procedure Main;
var
  i: LongInt;
  T, X, Y: LongInt;
begin
  ReadLn(N, Q);

  TotalSumOdd := 0;
  TotalPairs := 0;
  FillChar(C, SizeOf(C), 0);
  
  for i := 1 to N do
  begin
    Read(A[i]);
    if Odd(C[A[i]]) then
      TotalSumOdd := TotalSumOdd - A[i];
    
    TotalPairs := TotalPairs - (C[A[i]] div 2);
    C[A[i]] := C[A[i]] + 1;
    TotalPairs := TotalPairs + (C[A[i]] div 2);

    if (C[A[i]] div 2) <> ((C[A[i]] - 1) div 2) then
      UpdateTree(1, 1, N, A[i], C[A[i]] div 2);

    if Odd(C[A[i]]) then
      TotalSumOdd := TotalSumOdd + A[i];
  end;
  ReadLn; 

  for i := 1 to Q do
  begin
    Read(T);
    if T = 1 then
    begin
      ReadLn(X);
      Type1Query(X);
    end
    else
    begin
      ReadLn(X, Y);
      Type2Query(X, Y);
    end;
  end;
end;

begin
  Main;
end.